/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class Keyboard
implements Serializable {
    private static final int MAX_HISTORY = 100;
    private static final Hashtable keyMap = new Hashtable();
    private int[] rowMatrix = new int[8];
    private int[] columnMatrix = new int[8];
    private final Vector typedKeysBuffer = new Vector();
    private boolean isTyping = false;
    private int typeDelay = 0;
    private final Vector typedTexts = new Vector();
    private final StringBuffer currentText = new StringBuffer();
    private final Vector lastKeys = new Vector();
    private boolean hasCIARead = false;
    private boolean isShiftPressed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keyboard() {
        this.reset();
        Hashtable hashtable = keyMap;
        synchronized (hashtable) {
            if (keyMap.isEmpty()) {
                Keyboard.initializeKeyMap();
            }
        }
    }

    private static void initializeKeyMap() {
        keyMap.put("a", new KeyTableEntry(1, 2, false));
        keyMap.put("A", new KeyTableEntry(1, 2, false));
        keyMap.put("b", new KeyTableEntry(3, 4, false));
        keyMap.put("B", new KeyTableEntry(3, 4, false));
        keyMap.put("c", new KeyTableEntry(2, 4, false));
        keyMap.put("C", new KeyTableEntry(2, 4, false));
        keyMap.put("d", new KeyTableEntry(2, 2, false));
        keyMap.put("D", new KeyTableEntry(2, 2, false));
        keyMap.put("e", new KeyTableEntry(1, 6, false));
        keyMap.put("E", new KeyTableEntry(1, 6, false));
        keyMap.put("f", new KeyTableEntry(2, 5, false));
        keyMap.put("F", new KeyTableEntry(2, 5, false));
        keyMap.put("g", new KeyTableEntry(3, 2, false));
        keyMap.put("G", new KeyTableEntry(3, 2, false));
        keyMap.put("h", new KeyTableEntry(3, 5, false));
        keyMap.put("H", new KeyTableEntry(3, 5, false));
        keyMap.put("i", new KeyTableEntry(4, 1, false));
        keyMap.put("I", new KeyTableEntry(4, 1, false));
        keyMap.put("j", new KeyTableEntry(4, 2, false));
        keyMap.put("J", new KeyTableEntry(4, 2, false));
        keyMap.put("k", new KeyTableEntry(4, 5, false));
        keyMap.put("K", new KeyTableEntry(4, 5, false));
        keyMap.put("l", new KeyTableEntry(5, 2, false));
        keyMap.put("L", new KeyTableEntry(5, 2, false));
        keyMap.put("m", new KeyTableEntry(4, 4, false));
        keyMap.put("M", new KeyTableEntry(4, 4, false));
        keyMap.put("n", new KeyTableEntry(4, 7, false));
        keyMap.put("N", new KeyTableEntry(4, 7, false));
        keyMap.put("o", new KeyTableEntry(4, 6, false));
        keyMap.put("O", new KeyTableEntry(4, 6, false));
        keyMap.put("p", new KeyTableEntry(5, 1, false));
        keyMap.put("P", new KeyTableEntry(5, 1, false));
        keyMap.put("q", new KeyTableEntry(7, 6, false));
        keyMap.put("Q", new KeyTableEntry(7, 6, false));
        keyMap.put("r", new KeyTableEntry(2, 1, false));
        keyMap.put("R", new KeyTableEntry(2, 1, false));
        keyMap.put("s", new KeyTableEntry(1, 5, false));
        keyMap.put("S", new KeyTableEntry(1, 5, false));
        keyMap.put("t", new KeyTableEntry(2, 6, false));
        keyMap.put("T", new KeyTableEntry(2, 6, false));
        keyMap.put("u", new KeyTableEntry(3, 6, false));
        keyMap.put("U", new KeyTableEntry(3, 6, false));
        keyMap.put("v", new KeyTableEntry(3, 7, false));
        keyMap.put("V", new KeyTableEntry(3, 7, false));
        keyMap.put("w", new KeyTableEntry(1, 1, false));
        keyMap.put("W", new KeyTableEntry(1, 1, false));
        keyMap.put("x", new KeyTableEntry(2, 7, false));
        keyMap.put("X", new KeyTableEntry(2, 7, false));
        keyMap.put("y", new KeyTableEntry(3, 1, false));
        keyMap.put("Y", new KeyTableEntry(3, 1, false));
        keyMap.put("z", new KeyTableEntry(1, 4, false));
        keyMap.put("Z", new KeyTableEntry(1, 4, false));
        keyMap.put("0", new KeyTableEntry(4, 3, false));
        keyMap.put("1", new KeyTableEntry(7, 0, false));
        keyMap.put("2", new KeyTableEntry(7, 3, false));
        keyMap.put("3", new KeyTableEntry(1, 0, false));
        keyMap.put("4", new KeyTableEntry(1, 3, false));
        keyMap.put("5", new KeyTableEntry(2, 0, false));
        keyMap.put("6", new KeyTableEntry(2, 3, false));
        keyMap.put("7", new KeyTableEntry(3, 0, false));
        keyMap.put("8", new KeyTableEntry(3, 3, false));
        keyMap.put("9", new KeyTableEntry(4, 0, false));
        keyMap.put(" ", new KeyTableEntry(7, 4, false));
        keyMap.put("SPACE", new KeyTableEntry(7, 4, false));
        keyMap.put(",", new KeyTableEntry(5, 7, false));
        keyMap.put("<", new KeyTableEntry(5, 7, true));
        keyMap.put(".", new KeyTableEntry(5, 4, false));
        keyMap.put(">", new KeyTableEntry(5, 4, true));
        keyMap.put("=", new KeyTableEntry(6, 5, false));
        keyMap.put(":", new KeyTableEntry(5, 5, false));
        keyMap.put(";", new KeyTableEntry(6, 2, false));
        keyMap.put("+", new KeyTableEntry(5, 0, false));
        keyMap.put("-", new KeyTableEntry(5, 3, false));
        keyMap.put("*", new KeyTableEntry(6, 1, false));
        keyMap.put("ASTERISK", new KeyTableEntry(6, 1, false));
        keyMap.put("/", new KeyTableEntry(6, 7, false));
        keyMap.put("@", new KeyTableEntry(5, 6, false));
        keyMap.put("#", new KeyTableEntry(1, 0, true));
        keyMap.put("ARROW_LEFT", new KeyTableEntry(7, 1, false));
        keyMap.put("ESCAPE", new KeyTableEntry(7, 1, false));
        keyMap.put("ARROW_UP", new KeyTableEntry(6, 6, false));
        keyMap.put("HOME", new KeyTableEntry(6, 3, false));
        keyMap.put("RUN", new KeyTableEntry(7, 7, false));
        keyMap.put("DELETE", new KeyTableEntry(0, 0, false));
        keyMap.put("BACKSPACE", new KeyTableEntry(0, 0, false));
        keyMap.put("BACK_SPACE", new KeyTableEntry(0, 0, false));
        keyMap.put("POUND", new KeyTableEntry(6, 0, false));
        keyMap.put("SHIFT", new KeyTableEntry(1, 7, false));
        keyMap.put("AUTOSHIFT", new KeyTableEntry(1, 7, false));
        keyMap.put("CAPS_LOCK", new KeyTableEntry(6, 4, false));
        keyMap.put("COMMODORE", new KeyTableEntry(7, 5, false));
        keyMap.put("BREAK", new KeyTableEntry(7, 7, false));
        keyMap.put("\r", new KeyTableEntry(0, 1, false));
        keyMap.put("CONTROL", new KeyTableEntry(7, 2, false));
        keyMap.put("ENTER", new KeyTableEntry(0, 1, false));
        keyMap.put("DOWN", new KeyTableEntry(0, 7, false));
        keyMap.put("UP", new KeyTableEntry(0, 7, true));
        keyMap.put("RIGHT", new KeyTableEntry(0, 2, false));
        keyMap.put("LEFT", new KeyTableEntry(0, 2, true));
        keyMap.put("CURSOR DOWN", new KeyTableEntry(0, 7, false));
        keyMap.put("CURSOR UP", new KeyTableEntry(0, 7, true));
        keyMap.put("CURSOR RIGHT", new KeyTableEntry(0, 2, false));
        keyMap.put("CURSOR LEFT", new KeyTableEntry(0, 2, true));
        keyMap.put("F1", new KeyTableEntry(0, 4, false));
        keyMap.put("F3", new KeyTableEntry(0, 5, false));
        keyMap.put("F5", new KeyTableEntry(0, 6, false));
        keyMap.put("F7", new KeyTableEntry(0, 3, false));
        keyMap.put("!", new KeyTableEntry(7, 0, true));
        keyMap.put("\"", new KeyTableEntry(7, 3, true));
        keyMap.put("\ufffd", new KeyTableEntry(1, 0, true));
        keyMap.put("$", new KeyTableEntry(1, 3, true));
        keyMap.put("%", new KeyTableEntry(2, 0, true));
        keyMap.put("&", new KeyTableEntry(2, 3, true));
        keyMap.put("'", new KeyTableEntry(3, 0, true));
        keyMap.put("(", new KeyTableEntry(3, 3, true));
        keyMap.put(")", new KeyTableEntry(4, 0, true));
        keyMap.put("?", new KeyTableEntry(6, 7, true));
        keyMap.put("[", new KeyTableEntry(5, 5, true));
        keyMap.put("]", new KeyTableEntry(6, 2, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Keyboard keyboard = this;
        synchronized (keyboard) {
            int i = 0;
            while (i < 8) {
                this.rowMatrix[i] = 255;
                this.columnMatrix[i] = 255;
                ++i;
            }
            this.isTyping = false;
            this.isShiftPressed = false;
            this.typedKeysBuffer.removeAllElements();
            this.currentText.delete(0, this.currentText.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(String key) {
        KeyTableEntry ktEntry = (KeyTableEntry)keyMap.get(key);
        if (ktEntry != null) {
            Keyboard keyboard = this;
            synchronized (keyboard) {
                int row = ktEntry.row;
                int col = ktEntry.col;
                int n = row;
                this.rowMatrix[n] = this.rowMatrix[n] & 255 - (1 << col);
                int n2 = col;
                this.columnMatrix[n2] = this.columnMatrix[n2] & 255 - (1 << row);
                if (ktEntry.autoshift && !this.isShiftPressed) {
                    this.keyPressed("AUTOSHIFT");
                }
                this.lastKeys.addElement(key);
                this.hasCIARead = false;
                if ("SHIFT".equals(key)) {
                    this.isShiftPressed = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(String key) {
        KeyTableEntry ktEntry = (KeyTableEntry)keyMap.get(key);
        if (ktEntry != null) {
            Keyboard keyboard = this;
            synchronized (keyboard) {
                if (this.hasCIARead) {
                    int row = ktEntry.row;
                    int col = ktEntry.col;
                    int n = row;
                    this.rowMatrix[n] = this.rowMatrix[n] | 1 << col;
                    int n2 = col;
                    this.columnMatrix[n2] = this.columnMatrix[n2] | 1 << row;
                    if (ktEntry.autoshift && !this.isShiftPressed) {
                        this.keyReleased("AUTOSHIFT");
                    }
                    this.hasCIARead = false;
                    if ("SHIFT".equals(key)) {
                        this.isShiftPressed = false;
                    }
                    if (this.lastKeys.contains(key)) {
                        this.addToCurrentText(key);
                    }
                    this.lastKeys.removeElement(key);
                } else {
                    this.keyTyped(key, 0);
                }
            }
        }
    }

    public void keyTyped(String key) {
        this.typedKeysBuffer.addElement(key);
    }

    private void keyTyped(String key, int pos) {
        this.typedKeysBuffer.insertElementAt(key, pos);
    }

    public void textTyped(String text) {
        int i = 0;
        while (i < text.length()) {
            this.keyTyped(new Character(text.charAt(i)).toString());
            ++i;
        }
    }

    public Vector getTypedTexts() {
        return this.typedTexts;
    }

    private void addToCurrentText(String key) {
        if ("ENTER".equals(key) || "\n".equals(key) || "\r".equals(key)) {
            if (this.currentText.length() > 0) {
                this.typedTexts.removeElement(this.currentText.toString());
                this.typedTexts.insertElementAt(this.currentText.toString(), 0);
                if (this.typedTexts.size() > 100) {
                    this.typedTexts.removeElementAt(100);
                }
                this.currentText.delete(0, this.currentText.length());
            }
        } else if ("BACKSPACE".equals(key) || "DELETE".equals(key)) {
            if (this.currentText.length() > 0) {
                this.currentText.deleteCharAt(this.currentText.length() - 1);
            }
        } else if (key.length() > 1) {
            if (!"SHIFT".equals(key) && !"AUTOSHIFT".equals(key)) {
                this.currentText.delete(0, this.currentText.length());
            }
        } else {
            this.currentText.append(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getCIARegisterAdjustment(int testRegisterValue, int[] matrix) {
        int result = 255;
        Keyboard keyboard = this;
        synchronized (keyboard) {
            int i = 0;
            int mask = 1;
            while (i < 8) {
                if ((testRegisterValue & mask) == 0) {
                    result &= matrix[i];
                }
                mask <<= 1;
                ++i;
            }
            this.hasCIARead = true;
        }
        return (short)result;
    }

    public short getCIAPRAAdjustment(int testRegisterValue) {
        return this.getCIARegisterAdjustment(testRegisterValue, this.columnMatrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getCIAPRBAdjustment(int testRegisterValue) {
        short result = this.getCIARegisterAdjustment(testRegisterValue, this.rowMatrix);
        Keyboard keyboard = this;
        synchronized (keyboard) {
            if (this.typeDelay > 0) {
                --this.typeDelay;
            } else if (this.isTyping) {
                this.keyReleased((String)this.typedKeysBuffer.elementAt(0));
                this.typedKeysBuffer.removeElementAt(0);
                this.isTyping = false;
                this.typeDelay = 5;
            } else if (!this.typedKeysBuffer.isEmpty()) {
                this.keyPressed((String)this.typedKeysBuffer.elementAt(0));
                this.isTyping = true;
                this.typeDelay = 20;
            }
        }
        return result;
    }

    public static boolean hasShiftedVariant(String key) {
        KeyTableEntry entry = (KeyTableEntry)keyMap.get(key);
        return entry != null && !entry.autoshift && keyMap.contains(new KeyTableEntry(entry.row, entry.col, true));
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        SerializationUtils.serialize(out, this.rowMatrix);
        SerializationUtils.serialize(out, this.columnMatrix);
        out.writeInt(this.typedKeysBuffer.size());
        int i = 0;
        while (i < this.typedKeysBuffer.size()) {
            out.writeUTF(this.typedKeysBuffer.elementAt(i).toString());
            ++i;
        }
        out.writeBoolean(this.isTyping);
        out.writeInt(this.typeDelay);
        out.writeUTF(this.currentText.toString());
        out.writeBoolean(false);
        out.writeBoolean(this.hasCIARead);
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        SerializationUtils.deserialize(in, this.rowMatrix);
        SerializationUtils.deserialize(in, this.columnMatrix);
        this.typedKeysBuffer.removeAllElements();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.typedKeysBuffer.addElement(in.readUTF());
            ++i;
        }
        this.isTyping = in.readBoolean();
        this.typeDelay = in.readInt();
        if (this.currentText.length() > 0) {
            this.currentText.delete(0, this.currentText.length() - 1);
        }
        this.currentText.append(in.readUTF());
        in.readBoolean();
        this.hasCIARead = in.readBoolean();
    }

    static class KeyTableEntry {
        public final int row;
        public final int col;
        public final int code;
        public final boolean autoshift;

        public KeyTableEntry(int row, int col, boolean autoshift) {
            this.row = row;
            this.col = col;
            this.code = (row << 3) + col;
            this.autoshift = autoshift;
        }

        public int hashCode() {
            return this.code | (this.autoshift ? 64 : 0);
        }

        public boolean equals(Object other) {
            return other instanceof KeyTableEntry && other.hashCode() == this.hashCode();
        }

        public final String toString() {
            return String.valueOf(this.getClass().getName()) + "( " + this.row + ", " + this.col + ", " + this.autoshift + " )";
        }
    }
}

